---
title: Interesting Projects
description: List of interesting programming languages and informatics projects that I have discovered over the years
keywords: Interesting Programming Languges, Useful Projects, Best Parsing Library, Best Webpage Archival Tool, Best Embedded Database, Personal Notekeeping Tool, Zettlekasten Tool, Zettlekasten Notes
publish: true
date: 2022-05-22
uuid: 25aa57d4-cb67-476c-bdec-45a6ce7e694e
tags:
  - #kind/collection
  - #topic/informatics
  - #topic/projects
---

An updated list of some interesting projects that I have discovered over the years.
The projects contained here are either very functional and complete, and vastly superior to everything I have used in their domain of competence, or have a strong vision of what things should look like.

<!-- More -->

# Programming Languages
## Zig
[Zig](https://ziglang.org) [(Archived)](https://web.archive.org/web/20220420/https://ziglang.org) is a general-purpose programming language that aims to replace C.
The project is growing steadily and is well-maintained and well-structured.
One of the most amazing things for me is the ability to cross-compile for multiple targets (both different architectures and operating system) without having to install anything else.

## Svelte
[Svelte](https://github.com/sveltejs/svelte) [(Archived)](https://web.archive.org/web/20220420/https://github.com/sveltejs/svelte) is another language that compiles to Javascript, but it is completely rethought from the ground up. You program by writing reusable components that incorporate their HTML presentation together with CSS and their Javascript logic.
It brings joy in writing in Javascript, and has multiple awesome features like Server-Side-Rendering and the ability to write a common frontend-backend with APIs using [SvelteKit](https://kit.svelte.dev/) [(Archived)](https://web.archive.org/web/20220420/https://kit.svelte.dev/). Did I mention the ultra-small bundles?

## Red
[Red](https://github.com/red/red) [(Archived)](https://web.archive.org/web/20220420/https://github.com/red/red) is a new programming language inspired by [REBOL](https://www.rebol.com/) [(Archived)](https://web.archive.org/web/20220420/https://www.rebol.com/), which aims to be its successor. The scope of the project is very broad, includes a native-code compiler, and tries to replace basically every other language, while trying to fit into the single megabyte size of REBOL. Still in its infancy, but it is worth keeping an eye on it.

# Libraries and Tools
- **Linux Distro**: among the wide array of available distro I find [Fedora](https://getfedora.org/it/) [(Archived)](https://web.archive.org/web/20220621/https://getfedora.org/it/) extremely well done since it "just works", especially with Nvidia graphics modules which are a pain to get working in other distros.
- **Async Library**: [Trio](https://github.com/python-trio/trio) [(Archived)](https://web.archive.org/web/20220420/https://github.com/python-trio/trio) is an async library for Python, which is structured in clearly-defined and well-behaving primitives which allow you to retain your sanity.
- **Recursive Parsing**: the best library in this area is [Ohmjs](https://ohmjs.org) [(Archived)](https://web.archive.org/web/20220420/https://ohmjs.org), which is a packrat parser supporting both left- and right-recursion, incremental parsing of updates to original text, and rules with parameters.
- **Webpage Archival**: [freeze-dry](https://github.com/WebMemex/freeze-dry) [(Archived)](https://web.archive.org/web/20220420/https://github.com/WebMemex/freeze-dry) is the only project that has a sound idea on how to archive a page: it freezes the DOM as it is currently shown and inlines images and stylesheets.
- **Application Hosting**: [k3s](https://k3s.io) [(Archived)](https://web.archive.org/web/20220420/https://k3s.io) is a lightweight distribution of Kubernetes, which I find extremely easy to install and run. You need to have at least a small background in how containers like Docker work, but Kubernetes is in my opinion one of the best pieces of software for running workloads together without having to worry about everything.
- **Embedded Database**: [sqlite](https://sqlite.org/index.html) [(Archived)](https://web.archive.org/web/20220420/https://sqlite.org/index.html) is obviously well-known and it is awesome. I would like to also suggest [duckdb](https://github.com/duckdb/duckdb) [(Archived)](https://web.archive.org/web/20220420/https://github.com/duckdb/duckdb) which aims to support a richer set of operations like columnar data storage, interoperates with pandas dataframes and parquet files, and also supports SQL queries. For a document storage instead I find [acebase](https://github.com/appy-one/acebase) [(Archived)](https://web.archive.org/web/20220505/https://github.com/appy-one/acebase) really awesome, even implementing automatic client-server synchronization and OAuth logins with multiple providers, but lacking an automated test suite it is somewhat inconsistent in reliability.
- **Personal Notekeeping**: [Obsidian](https://obsidian.md/) [(Archived)](https://web.archive.org/web/20220420/https://obsidian.md/) is a freeware desktop application for organizing notes in Markdown. Has an enormous amount of plugins for basically everything, and you can develop your own if you are missing some functionality. Really one of the most complete note-taking applications I have ever seen, including cross-notes linking. Unfortunately it is not open-source.
- **Reproducibility**: [conda](https://docs.conda.io/en/latest/) [(Archived)](https://web.archive.org/web/20220420/https://docs.conda.io/en/latest/) is a package dependency management for many common languages with lots of compiled packages already available. [dvc](https://github.com/iterative/dvc) [(Archived)](https://web.archive.org/web/20220420/https://github.com/iterative/dvc) allows you to keep track of data versioning and script dependencies inside your git repository while storing the data on other platforms; ideal for lots of data, machine-learning-style.
- **Download CLI Utility**: [aria2](https://github.com/aria2/aria2) [(Archived)](https://web.archive.org/web/20220420/https://github.com/aria2/aria2), a multi-protocol download utility supporting HTTP/HTTPS, FTP/SFTP, Magnets and BitTorrent.
- **Personal Data Management**: I store everything that I produce in [git](https://git-scm.com/) [(Archived)](https://web.archive.org/web/20220505/https://git-scm.com/) repositories, and I find [gitbackup](https://github.com/amitsaha/gitbackup) [(Archived)](https://web.archive.org/web/20220505/https://github.com/amitsaha/gitbackup) an extremely useful tool to backup my hosted git repos.
